package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewStaticBlockPaletteObjectWizard extends JPanel {
	
	
	
	private SharedColor transparentColor;
	private MicroColorCanvas colorCanvas;
	private JTextField imageField;
	
	private JCheckBox blockIsPassThrough;
	
	private Window encasingFrame;
	
	
	private String imageFileName;
	private boolean shouldBePassThrough;
	
	private boolean wasCancelled;
	
	public NewStaticBlockPaletteObjectWizard(Window theFrame) {
		
		this.setLayout(new BorderLayout());
		
		encasingFrame = theFrame;
		wasCancelled = false;
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
		mainPanel.add(new JPanel());
		
		JPanel imagePanel = new JPanel();
		imagePanel.setLayout(new FlowLayout());
		imagePanel.add(new JLabel("Static Block Image: "));
		imageField = new JTextField(20);
		imageField.setHorizontalAlignment(JTextField.CENTER);
		imageField.setEditable(false);
		imagePanel.add(imageField);
		JButton imageButton = new JButton("Browse...");
		imageButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				NewRoomSetupWizard.retrieveImageFile(imageField, encasingFrame);
			}
		});
		imagePanel.add(imageButton);
		mainPanel.add(encaseInFlowLayout(imagePanel));
		
		JPanel colorPanel = new JPanel();
		colorPanel.setLayout(new FlowLayout());
		colorPanel.add(new JLabel("Transparent Color: "));
		transparentColor = new SharedColor();
		colorCanvas = new MicroColorCanvas(transparentColor);
		colorPanel.add(colorCanvas);
		JButton colorButton = new JButton("Change...");
		colorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, colorCanvas);
			}
		});
		colorPanel.add(colorButton);
		mainPanel.add(colorPanel);
		
		blockIsPassThrough = new JCheckBox(" Block should be pass-through");
		mainPanel.add(encaseInFlowLayout(blockIsPassThrough));
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				wasCancelled = true;
				encasingFrame.setVisible(false);
				encasingFrame.dispose();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				okWasPressed();
			}
		});
		bottomPanel.add(okButton);
		
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
	}
	
	
	

	public NewStaticBlockPaletteObjectWizard(Window theFrame, String origFileName, Color origColor, boolean origPassThru) {
		
		this.setLayout(new BorderLayout());
		
		encasingFrame = theFrame;
		wasCancelled = false;
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
		mainPanel.add(new JPanel());
		
		JPanel imagePanel = new JPanel();
		imagePanel.setLayout(new FlowLayout());
		imagePanel.add(new JLabel("Static Block Image: "));
		imageField = new JTextField(20);
		imageField.setHorizontalAlignment(JTextField.CENTER);
		imageField.setEditable(false);
		imageField.setText(origFileName);
		imagePanel.add(imageField);
		JButton imageButton = new JButton("Browse...");
		imageButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				NewRoomSetupWizard.retrieveImageFile(imageField, encasingFrame);
			}
		});
		imagePanel.add(imageButton);
		mainPanel.add(encaseInFlowLayout(imagePanel));
		
		JPanel colorPanel = new JPanel();
		colorPanel.setLayout(new FlowLayout());
		colorPanel.add(new JLabel("Transparent Color: "));
		transparentColor = new SharedColor();
		transparentColor.setColor(origColor);
		colorCanvas = new MicroColorCanvas(transparentColor);
		colorPanel.add(colorCanvas);
		JButton colorButton = new JButton("Change...");
		colorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, colorCanvas);
			}
		});
		colorPanel.add(colorButton);
		mainPanel.add(colorPanel);
		
		blockIsPassThrough = new JCheckBox(" Block should be pass-through");
		if(origPassThru)
			blockIsPassThrough.setSelected(true);
		mainPanel.add(encaseInFlowLayout(blockIsPassThrough));
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				wasCancelled = true;
				encasingFrame.setVisible(false);
				encasingFrame.dispose();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				okWasPressed();
			}
		});
		bottomPanel.add(okButton);
		
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
	}
	
	
	
	public static void main(String [] args) {
		
		
		JFrame frame = new JFrame();
		
		NewStaticBlockPaletteObjectWizard wizard = new NewStaticBlockPaletteObjectWizard(frame);
		
		frame.setContentPane(wizard);
		
		frame.setPreferredSize(new Dimension(500, 300));
		frame.setMinimumSize(new Dimension(500, 300));
		frame.setMaximumSize(new Dimension(500, 300));
		
		frame.setVisible(true);
		
	}
	
	
	private JPanel encaseInFlowLayout(Component c) {
		JPanel returnValue = new JPanel();
		returnValue.setLayout(new FlowLayout());
		returnValue.add(c);
		return returnValue;
	}
	
	
	
	public void okWasPressed() {
		
		StringBuffer messages = new StringBuffer();
		
		if(transparentColor.getColor() == null) {
			messages.append("You must select a transparent color.\n");
		}
		
		if(imageField.getText() == null || imageField.getText().length() == 0) {
			messages.append("You must select an image file for the static block.\n");
		}
		
		
		if(messages.length() != 0) {

			JOptionPane.showMessageDialog(this, "Not all fields are valid:\n\n" + messages.toString(), "Error occurred", JOptionPane.ERROR_MESSAGE);
			
		} else {
			
			shouldBePassThrough = this.blockIsPassThrough.isSelected();
			
			imageFileName = imageField.getText();
			wasCancelled = false;
			
			encasingFrame.setVisible(false);
			encasingFrame.dispose();
			
		}
		
	}
	
	public boolean wasCancelled() {
		return wasCancelled;
	}
	
	public String getImageFileName() {
		return imageFileName;
	}
	
	public Color getTransparentColor() {
		return transparentColor.getColor();
	}
	
	public boolean shouldBePassThrough() {
		return shouldBePassThrough;
	}
	
}
